// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2 -target-feature +sve -target-feature +sve-bfscale -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="" streaming_guard="sme,sme2,sve-bfscale" flags="streaming-only"

void test(void) {
  svbfloat16_t svbfloat16_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svbfloat16x4_t svbfloat16x4_t_val;
  svint16_t svint16_t_val;
  svint16x2_t svint16x2_t_val;
  svint16x4_t svint16x4_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x2_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x2_t_val, svbfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x4_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x4_t_val, svbfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_bf16_x2(svbfloat16x2_t_val, svbfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_bf16_x4(svbfloat16x4_t_val, svbfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_bf16_x2(svbfloat16x2_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_bf16_x4(svbfloat16x4_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x2_t_val, svint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x2_t_val, svint16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x4_t_val, svint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x4_t_val, svint16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_bf16_x2(svbfloat16x2_t_val, svint16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_bf16_x4(svbfloat16x4_t_val, svint16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_single_bf16_x2(svbfloat16x2_t_val, svint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_single_bf16_x4(svbfloat16x4_t_val, svint16_t_val);
}

void test_streaming(void) __arm_streaming{
  svbfloat16_t svbfloat16_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svbfloat16x4_t svbfloat16x4_t_val;
  svint16_t svint16_t_val;
  svint16x2_t svint16x2_t_val;
  svint16x4_t svint16x4_t_val;

  svmul(svbfloat16x2_t_val, svbfloat16_t_val);
  svmul(svbfloat16x2_t_val, svbfloat16x2_t_val);
  svmul(svbfloat16x4_t_val, svbfloat16_t_val);
  svmul(svbfloat16x4_t_val, svbfloat16x4_t_val);
  svmul_bf16_x2(svbfloat16x2_t_val, svbfloat16x2_t_val);
  svmul_bf16_x4(svbfloat16x4_t_val, svbfloat16x4_t_val);
  svmul_single_bf16_x2(svbfloat16x2_t_val, svbfloat16_t_val);
  svmul_single_bf16_x4(svbfloat16x4_t_val, svbfloat16_t_val);
  svscale(svbfloat16x2_t_val, svint16_t_val);
  svscale(svbfloat16x2_t_val, svint16x2_t_val);
  svscale(svbfloat16x4_t_val, svint16_t_val);
  svscale(svbfloat16x4_t_val, svint16x4_t_val);
  svscale_bf16_x2(svbfloat16x2_t_val, svint16x2_t_val);
  svscale_bf16_x4(svbfloat16x4_t_val, svint16x4_t_val);
  svscale_single_bf16_x2(svbfloat16x2_t_val, svint16_t_val);
  svscale_single_bf16_x4(svbfloat16x4_t_val, svint16_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svbfloat16_t svbfloat16_t_val;
  svbfloat16x2_t svbfloat16x2_t_val;
  svbfloat16x4_t svbfloat16x4_t_val;
  svint16_t svint16_t_val;
  svint16x2_t svint16x2_t_val;
  svint16x4_t svint16x4_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x2_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x2_t_val, svbfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x4_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul(svbfloat16x4_t_val, svbfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_bf16_x2(svbfloat16x2_t_val, svbfloat16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_bf16_x4(svbfloat16x4_t_val, svbfloat16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_bf16_x2(svbfloat16x2_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svmul_single_bf16_x4(svbfloat16x4_t_val, svbfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x2_t_val, svint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x2_t_val, svint16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x4_t_val, svint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale(svbfloat16x4_t_val, svint16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_bf16_x2(svbfloat16x2_t_val, svint16x2_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_bf16_x4(svbfloat16x4_t_val, svint16x4_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_single_bf16_x2(svbfloat16x2_t_val, svint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svscale_single_bf16_x4(svbfloat16x4_t_val, svint16_t_val);
}
