
``` asciidoc
cpp:std::vector[]
```

This will render as a link to the `std::vector` class in the tagfile.

``` asciidoc
https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]
```

Which renders as
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]`.

The extension supports fundamental types, custom tagfiles, using
namespaces directives, template parameters, nested symbols, and
replacing target names.

## Configuration

### npm

Install this extension

``` bash
npm i -D @cppalliance/antora-cpp-tagfiles-extension
```

### Playbook

Append the following in your `antora-playbook.yaml`:

``` yaml
antora:
  extensions:
    - require: '@cppalliance/antora-cpp-tagfiles-extension' # 
      cpp-tagfiles:
          files: # 
            - file: ./doc/tagfiles/boost-url-doxygen.tag.xml
              base_url: 'xref:reference:'
            - file: ./doc/tagfiles/boost-system-doxygen.tag.xml
              base_url: https://www.boost.org/doc/libs/master/libs/system/doc/html/
            - file: ./doc/tagfiles/boost-core-doxygen.tag.xml
              base_url: https://www.boost.org/doc/libs/master/libs/core/doc/html/
            - file: ./doc/tagfiles/boost-filesystem-doxygen.tag.xml
              base_url: https://www.boost.org/doc/libs/master/libs/filesystem/doc/
          using-namespaces: 
            - boost::urls
            - boost::urls::grammar
            - boost::system
            - boost::core
```

-   \<1\> `npm` package name:
    `@cppalliance/antora-cpp-tagfiles-extension` (required)

-   \<2\> List of tagfiles to be used by the extension

-   \<3\> List of namespaces to be used by the extension

### Components

Components can also set their own tagfiles. Append following in your
`antora.yaml`:

``` yaml
ext:
  cpp-tagfiles: # 
      files: # 
        - file: ./doc/tagfiles/boost-url-doxygen.tag.xml
          base_url: 'xref:reference:'
        - file: ./doc/tagfiles/boost-system-doxygen.tag.xml
          base_url: https://www.boost.org/doc/libs/master/libs/system/doc/html/
        - file: ./doc/tagfiles/boost-core-doxygen.tag.xml
          base_url: https://www.boost.org/doc/libs/master/libs/core/doc/html/
        - file: ./doc/tagfiles/boost-filesystem-doxygen.tag.xml
          base_url: https://www.boost.org/doc/libs/master/libs/filesystem/doc/
      using-namespaces: 
        - boost::urls
        - boost::urls::grammar
        - boost::system
        - boost::core
```

-   \<1\> The playbook needs to have the extension enabled

-   \<2\> List of tagfiles to be used by the component

-   \<3\> List of namespaces to be used by the component

These tagfiles only affect the component where they are defined.

###  {#_}

The extension include the cppreference tagfile by default. Any unknown
symbol in custom tagfiles will be searched in the cppreference tagfile.

### Using the reference extension

When `@cppalliance/antora-cpp-reference-extension`
(<https://github.com/cppalliance/antora-cpp-reference-extension>) is
present in the same playbook the reference tagfile is registered
automatically, so `cpp:` macros can link to the pages generated during
the same build. If you override the module name via `module`, that
module's `xref:` prefix is carried along automatically and no extra
configuration is necessary:

``` yaml
antora:
  extensions:
    - require: '@cppalliance/antora-cpp-reference-extension'
    - require: '@cppalliance/antora-cpp-tagfiles-extension'
```

You can still list extra tagfiles in the playbook or component
descriptors if you need to point at other libraries, but the generated
reference module is picked up automatically.

## Features

### Unknown symbols

If the extension can't find a symbol in the tagfile, it will render the
symbol as plain text.

``` asciidoc
cpp:unknown[]
```

This will render as plain text:

``` asciidoc
`unknown`
```

Which renders as `unknown`.

### Fundamental types

Fundamental types include links to cppreference:

``` asciidoc
cpp:int[]
```

This will render as a link to the `int` fundamental type in
cppreference.

``` asciidoc
`https://en.cppreference.com/w/cpp/language/types#Standard_integer_types[int,window="_blank"]`
```

Which renders as
`https://en.cppreference.com/w/cpp/language/types#Standard_integer_types[int,window="_blank"]`.

### Symbols from Tagfiles

Symbols from tagfiles are rendered as links:

``` asciidoc
cpp:std::string[]
```

This will render as a link to the `std::string` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/string/basic_string[std::string,window="_blank"]`
```

Which renders as
`https://en.cppreference.com/w/cpp/string/basic_string[std::string,window="_blank"]`.

Template classes without parameters are also supported:

``` asciidoc
cpp:std::vector[]
```

This will render as a link to the `std::vector` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]`
```

Which renders as
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]`.

Symbols from custom tagfiles are rendered without the `window="_blank"`
attribute if the `base_url` relative.

``` asciidoc
cpp:is_charset[]
```

This will render as a link to the `boost::urls::grammar::is_charset`
class in the `boost-url-doxygen.tag.xml` tagfile.

``` asciidoc
`xref:reference:boost/urls/grammar/is_charset.adoc[boost::urls::grammar::is_charset]`
```

### Components

When components define their own tagfiles, these tagfiles only affect
the component where they are defined and they have precedence over
tagfiles defined in the playbook.

``` asciidoc
cpp:boost::urls::string_token::assign_to[]
```

This will render as a link to the `boost::urls::string_token::assign_to`
class in the `boost-url-doxygen.tag.xml` tagfile.

``` asciidoc
`xref:reference:boost/urls/string_token/assign_to.adoc[boost::urls::string_token::assign_to]`
```

However, if the some other component uses `cpp:` for the same symbol
without the appropriate tagfile, the symbol will be rendered as plain
text.

``` asciidoc
`boost::urls::string_token::assign_to`
```

### Namespaces

Default namespaces can also be defined in the playbook or in the
component. When there's no match for the full symbol, the extension will
try to find the symbol in the namespaces. Assuming
`boost::urls::grammar` is defined in the playbook or the component:

``` asciidoc
cpp:boost::urls::grammar::is_charset[]
cpp:is_charset[]
```

This will render as a link to the `boost::urls::grammar::is_charset`
class in the `boost-url-doxygen.tag.xml` tagfile. However, the link text
will be whatever was provided to the extension.

``` asciidoc
`xref:reference:boost/urls/grammar/is_charset.adoc[boost::urls::grammar::is_charset]`
`xref:reference:boost/urls/grammar/is_charset.adoc[is_charset]`
```

As with tagfiles, the namespaces defined in a component only affect that
component. The namespace `std::` can also be defined:

``` asciidoc
cpp:std::string[]
cpp:string[]
```

This will render as a link to the `std::string` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/string/basic_string[std::string,window="_blank"]`
`https://en.cppreference.com/w/cpp/string/basic_string[string,window="_blank"]`
```

### Template parameters

Template parameters are supported. The extension will also include links
from the tagfile for the template parameters.

``` asciidoc
cpp:std::vector<int>[]
```

This will render as a link to the `std::vector<int>` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]<https://en.cppreference.com/w/cpp/language/types#Standard_integer_types[int,window=_blank]>`
```

Which renders as
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]<https://en.cppreference.com/w/cpp/language/types#Standard_integer_types[int,window=_blank]>`.

Symbols from custom tagfiles can also be used with template parameters:

``` asciidoc
cpp:std::vector<url_view>[]
```

This will render as a link to the `std::vector<url_view>` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window=\"_blank\"]&#x3C;url_view&#x3E;`
```

Which renders as
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="blank"]<url_view>`.

If the namespace `boost::urls` is being used in the context, it will
also be used to resolve `url_view`:

``` asciidoc
cpp:std::vector<url_view>[]
```

This will render as a link to the `std::vector<url_view>` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window=\"_blank\"]&#x3C;xref:reference:boost/urls/url_view.adoc[url_view]&#x3E;`
```

### Nested symbols

The extension supports nested symbols:

``` asciidoc
cpp:boost::urls::url_view_base::segments[]
```

This will render as a link to the `boost::urls::url_view_base::segments`
class in the `boost-url-doxygen.tag.xml` tagfile.

``` asciidoc
`xref:reference:boost/urls/url_view_base/segments.adoc[boost::urls::url_view_base::segments]`
```

Which is the page for the `boost::urls::url_view_base::segments` symbol
defined in the tagfile rather than only `boost::urls::url_view_base`.

Sometimes there's no page for the nested symbol in the tagfile, so the
link will redirect to the page for the parent symbol.

``` asciidoc
cpp:std::vector::iterator[]
```

This will render as a link to the `std::vector` class in the
cppreference tagfile:

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[std::vector::iterator,window=\"_blank\"]`
```

Which renders as
`https://en.cppreference.com/w/cpp/container/vector[std::vector::iterator,window="blank"]`.

Note that there's no page for `std::vector::iterator` in cppreference,
so the link will redirect to the page for the parent `std::vector`
symbol.

Templates and nested symbols can also be combined:

``` asciidoc
cpp:std::vector<url_view_base::segments>::iterator[]
```

This will render as a link to the
`std::vector<url_view_base::segments>::iterator` class in the
cppreference tagfile.

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[std::vector,window="_blank"]&#x3C;xref:reference:boost/urls/url_view_base/segments.adoc[url_view_base::segments]&#x3E;::https://en.cppreference.com/w/cpp/container/vector[std::vector::iterator,window="_blank"]
`
```

### Replacing target names

The extension can replace the target names of the links.

``` asciidoc
cpp:std::vector[sequential container]
```

This will render as a link to the `std::vector` class in the
cppreference tagfile with the text \"sequential container\".

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[sequential container,window="_blank"]`
```

Which renders as
`https://en.cppreference.com/w/cpp/container/vector[sequential container,window="_blank"]`.

When providing custom text for a template class, the extension will only
link the main symbol:

``` asciidoc
cpp:std::vector<int>[sequential container]
```

This will render as a link to the `std::vector` class in the
cppreference tagfile with the text \"sequential container\".

``` asciidoc
`https://en.cppreference.com/w/cpp/container/vector[sequential container,window="_blank"]`
```

Which also renders as
`https://en.cppreference.com/w/cpp/container/vector[sequential container,window="_blank"]`.

``` asciidoc
cpp:url_view_base::segments[URL segments]
```

This will render as a link to the `boost::urls::url_view_base::segments`
class in the `boost-url-doxygen.tag.xml` tagfile with the text \"URL
segments\".

``` asciidoc
`xref:reference:boost/urls/url_view_base/segments.adoc[URL segments]`
```
