.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XCreateIC __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XCreateIC, XDestroyIC, XIMOfIC \- create, destroy, and obtain the input method of an input context
.SH SYNTAX
.HP
XIC XCreateIC\^(\^XIM \fIim\fP\^, ...\^);
.HP
void XDestroyIC\^(\^XIC \fIic\fP\^);
.HP
XIM XIMOfIC\^(\^XIC \fIic\fP\^);
.SH ARGUMENTS
.IP \fIic\fP 1i
Specifies the input context.
.IP \fIim\fP 1i
Specifies the input method.
.IP ... 1i
Specifies the variable length argument list to set XIC values.
.SH DESCRIPTION
The
.B XCreateIC
function creates a context within the specified input method.
.LP
Some of the arguments are mandatory at creation time, and
the input context will not be created if those arguments are not provided.
The mandatory arguments are the input style and the set of text callbacks
(if the input style selected requires callbacks).
All other input context values can be set later.
.LP
.B XCreateIC
returns a NULL value if no input context could be created.
A NULL value could be returned for any of the following reasons:
.IP \(bu 5
A required argument was not set.
.IP \(bu 5
A read-only argument was set (for example,
.BR XNFilterEvents ).
.IP \(bu 5
The argument name is not recognized.
.IP \(bu 5
The input method encountered an input method implementation-dependent error.
.LP
The
.B XCreateIC
can generate
.BR BadAtom ,
.BR BadColor ,
.BR BadPixmap ,
and
.B BadWindow
errors.
.LP
.B XDestroyIC
destroys the specified input context.
.LP
The
.B XIMOfIC
function returns the input method associated with the specified input context.
.SH DIAGNOSTICS
.TP 1i
.B BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.B BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.B BadPixmap
A value for a Pixmap argument does not name a defined Pixmap.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XOpenIM (__libmansuffix__),
.BR XSetICFocus (__libmansuffix__),
.BR XSetICValues (__libmansuffix__),
.BR XmbResetIC (__libmansuffix__)
.br
\fI\*(xL\fP
