.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XcmsSetWhitePoint __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XcmsSetWhitePoint, XcmsSetWhiteAdjustProc \- modifying CCC attributes
.SH SYNTAX
.HP
Status XcmsSetWhitePoint\^(\^XcmsCCC \fIccc\fP\^, XcmsColor *\fIcolor\fP\^);
.HP
XcmsWhiteAdjustProc XcmsSetWhiteAdjustProc\^(\^XcmsCCC \fIccc\fP\^,
XcmsWhiteAdjustProc \fIwhite_adjust_proc\fP\^, XPointer \fIclient_data\fP\^);
.SH ARGUMENTS
.IP \fIccc\fP 1i
Specifies the CCC.
.IP \fIclient_data\fP 1i
Specifies client data for the white point adjustment procedure or NULL.
.IP \fIcolor\fP 1i
Specifies the new Client White Point.
.IP \fIwhite_adjust_proc\fP 1i
Specifies the white point adjustment procedure.
.SH DESCRIPTION
The
.B XcmsSetWhitePoint
function changes the Client White Point in the specified CCC.
Note that the pixel member is ignored
and that the color specification is left unchanged upon return.
The format for the new white point must be
.BR XcmsCIEXYZFormat ,
.BR XcmsCIEuvYFormat ,
.BR XcmsCIExyYFormat ,
or
.BR XcmsUndefinedFormat .
If the color argument is NULL, this function sets the format component of the
Client White Point specification to
.BR XcmsUndefinedFormat ,
indicating that the Client White Point is assumed to be the same as the
Screen White Point.
.LP
This function returns nonzero status
if the format for the new white point is valid;
otherwise, it returns zero.

.LP
The
.B XcmsSetWhiteAdjustProc
function first sets the white point adjustment procedure and client data
in the specified CCC with the newly specified procedure and client data
and then returns the old procedure.
.SH "SEE ALSO"
.BR DisplayOfCCC (__libmansuffix__),
.BR XcmsCCCOfColormap (__libmansuffix__),
.BR XcmsConvertColors (__libmansuffix__),
.BR XcmsCreateCCC (__libmansuffix__),
.BR XcmsDefaultCCC (__libmansuffix__)
.br
\fI\*(xL\fP
